/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachToIndexRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, AttachToIndexRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(AttachToIndexRequest.getter(AttachToIndexRequest::directoryArn)).setter(AttachToIndexRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<ObjectReference> INDEX_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IndexReference").getter(AttachToIndexRequest.getter(AttachToIndexRequest::indexReference)).setter(AttachToIndexRequest.setter(Builder::indexReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexReference").build()}).build();
    private static final SdkField<ObjectReference> TARGET_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetReference").getter(AttachToIndexRequest.getter(AttachToIndexRequest::targetReference)).setter(AttachToIndexRequest.setter(Builder::targetReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, INDEX_REFERENCE_FIELD, TARGET_REFERENCE_FIELD));
    private final String directoryArn;
    private final ObjectReference indexReference;
    private final ObjectReference targetReference;

    private AttachToIndexRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.indexReference = builder.indexReference;
        this.targetReference = builder.targetReference;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    public final ObjectReference indexReference() {
        return this.indexReference;
    }

    public final ObjectReference targetReference() {
        return this.targetReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachToIndexRequest)) {
            return false;
        }
        AttachToIndexRequest other = (AttachToIndexRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.indexReference(), other.indexReference()) && Objects.equals(this.targetReference(), other.targetReference());
    }

    public final String toString() {
        return ToString.builder((String)"AttachToIndexRequest").add("DirectoryArn", (Object)this.directoryArn()).add("IndexReference", (Object)this.indexReference()).add("TargetReference", (Object)this.targetReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "IndexReference": {
                return Optional.ofNullable(clazz.cast(this.indexReference()));
            }
            case "TargetReference": {
                return Optional.ofNullable(clazz.cast(this.targetReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachToIndexRequest, T> g) {
        return obj -> g.apply((AttachToIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference indexReference;
        private ObjectReference targetReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachToIndexRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.indexReference(model.indexReference);
            this.targetReference(model.targetReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        @Transient
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final ObjectReference.Builder getIndexReference() {
            return this.indexReference != null ? this.indexReference.toBuilder() : null;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        @Override
        @Transient
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final ObjectReference.Builder getTargetReference() {
            return this.targetReference != null ? this.targetReference.toBuilder() : null;
        }

        public final void setTargetReference(ObjectReference.BuilderImpl targetReference) {
            this.targetReference = targetReference != null ? targetReference.build() : null;
        }

        @Override
        @Transient
        public final Builder targetReference(ObjectReference targetReference) {
            this.targetReference = targetReference;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachToIndexRequest build() {
            return new AttachToIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachToIndexRequest> {
        public Builder directoryArn(String var1);

        public Builder indexReference(ObjectReference var1);

        default public Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return this.indexReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(indexReference)).build());
        }

        public Builder targetReference(ObjectReference var1);

        default public Builder targetReference(Consumer<ObjectReference.Builder> targetReference) {
            return this.targetReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(targetReference)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

