/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeType;
import software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior;
import software.amazon.awssdk.services.clouddirectory.model.Rule;
import software.amazon.awssdk.services.clouddirectory.model.RuleMapCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypedLinkAttributeDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypedLinkAttributeDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TypedLinkAttributeDefinition.getter(TypedLinkAttributeDefinition::name)).setter(TypedLinkAttributeDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TypedLinkAttributeDefinition.getter(TypedLinkAttributeDefinition::typeAsString)).setter(TypedLinkAttributeDefinition.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<TypedAttributeValue> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultValue").getter(TypedLinkAttributeDefinition.getter(TypedLinkAttributeDefinition::defaultValue)).setter(TypedLinkAttributeDefinition.setter(Builder::defaultValue)).constructor(TypedAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<Boolean> IS_IMMUTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsImmutable").getter(TypedLinkAttributeDefinition.getter(TypedLinkAttributeDefinition::isImmutable)).setter(TypedLinkAttributeDefinition.setter(Builder::isImmutable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsImmutable").build()}).build();
    private static final SdkField<Map<String, Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Rules").getter(TypedLinkAttributeDefinition.getter(TypedLinkAttributeDefinition::rules)).setter(TypedLinkAttributeDefinition.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REQUIRED_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequiredBehavior").getter(TypedLinkAttributeDefinition.getter(TypedLinkAttributeDefinition::requiredBehaviorAsString)).setter(TypedLinkAttributeDefinition.setter(Builder::requiredBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, DEFAULT_VALUE_FIELD, IS_IMMUTABLE_FIELD, RULES_FIELD, REQUIRED_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final TypedAttributeValue defaultValue;
    private final Boolean isImmutable;
    private final Map<String, Rule> rules;
    private final String requiredBehavior;

    private TypedLinkAttributeDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.isImmutable = builder.isImmutable;
        this.rules = builder.rules;
        this.requiredBehavior = builder.requiredBehavior;
    }

    public final String name() {
        return this.name;
    }

    public final FacetAttributeType type() {
        return FacetAttributeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final TypedAttributeValue defaultValue() {
        return this.defaultValue;
    }

    public final Boolean isImmutable() {
        return this.isImmutable;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructMap);
    }

    public final Map<String, Rule> rules() {
        return this.rules;
    }

    public final RequiredAttributeBehavior requiredBehavior() {
        return RequiredAttributeBehavior.fromValue(this.requiredBehavior);
    }

    public final String requiredBehaviorAsString() {
        return this.requiredBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.isImmutable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkAttributeDefinition)) {
            return false;
        }
        TypedLinkAttributeDefinition other = (TypedLinkAttributeDefinition)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.isImmutable(), other.isImmutable()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.requiredBehaviorAsString(), other.requiredBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TypedLinkAttributeDefinition").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("DefaultValue", (Object)this.defaultValue()).add("IsImmutable", (Object)this.isImmutable()).add("Rules", this.hasRules() ? this.rules() : null).add("RequiredBehavior", (Object)this.requiredBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "IsImmutable": {
                return Optional.ofNullable(clazz.cast(this.isImmutable()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "RequiredBehavior": {
                return Optional.ofNullable(clazz.cast(this.requiredBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypedLinkAttributeDefinition, T> g) {
        return obj -> g.apply((TypedLinkAttributeDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private TypedAttributeValue defaultValue;
        private Boolean isImmutable;
        private Map<String, Rule> rules = DefaultSdkAutoConstructMap.getInstance();
        private String requiredBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkAttributeDefinition model) {
            this.name(model.name);
            this.type(model.type);
            this.defaultValue(model.defaultValue);
            this.isImmutable(model.isImmutable);
            this.rules(model.rules);
            this.requiredBehavior(model.requiredBehavior);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FacetAttributeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final TypedAttributeValue.Builder getDefaultValue() {
            return this.defaultValue != null ? this.defaultValue.toBuilder() : null;
        }

        @Override
        public final Builder defaultValue(TypedAttributeValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(TypedAttributeValue.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        public final Boolean getIsImmutable() {
            return this.isImmutable;
        }

        @Override
        public final Builder isImmutable(Boolean isImmutable) {
            this.isImmutable = isImmutable;
            return this;
        }

        public final void setIsImmutable(Boolean isImmutable) {
            this.isImmutable = isImmutable;
        }

        public final Map<String, Rule.Builder> getRules() {
            if (this.rules instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.rules != null ? CollectionUtils.mapValues(this.rules, Rule::toBuilder) : null;
        }

        @Override
        public final Builder rules(Map<String, Rule> rules) {
            this.rules = RuleMapCopier.copy(rules);
            return this;
        }

        public final void setRules(Map<String, Rule.BuilderImpl> rules) {
            this.rules = RuleMapCopier.copyFromBuilder(rules);
        }

        public final String getRequiredBehavior() {
            return this.requiredBehavior;
        }

        @Override
        public final Builder requiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
            return this;
        }

        @Override
        public final Builder requiredBehavior(RequiredAttributeBehavior requiredBehavior) {
            this.requiredBehavior(requiredBehavior == null ? null : requiredBehavior.toString());
            return this;
        }

        public final void setRequiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
        }

        public TypedLinkAttributeDefinition build() {
            return new TypedLinkAttributeDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypedLinkAttributeDefinition> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(FacetAttributeType var1);

        public Builder defaultValue(TypedAttributeValue var1);

        default public Builder defaultValue(Consumer<TypedAttributeValue.Builder> defaultValue) {
            return this.defaultValue((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().applyMutation(defaultValue)).build());
        }

        public Builder isImmutable(Boolean var1);

        public Builder rules(Map<String, Rule> var1);

        public Builder requiredBehavior(String var1);

        public Builder requiredBehavior(RequiredAttributeBehavior var1);
    }
}

