/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectAttributesRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, ListObjectAttributesRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(ListObjectAttributesRequest.getter(ListObjectAttributesRequest::directoryArn)).setter(ListObjectAttributesRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ObjectReference").getter(ListObjectAttributesRequest.getter(ListObjectAttributesRequest::objectReference)).setter(ListObjectAttributesRequest.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListObjectAttributesRequest.getter(ListObjectAttributesRequest::nextToken)).setter(ListObjectAttributesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListObjectAttributesRequest.getter(ListObjectAttributesRequest::maxResults)).setter(ListObjectAttributesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsistencyLevel").getter(ListObjectAttributesRequest.getter(ListObjectAttributesRequest::consistencyLevelAsString)).setter(ListObjectAttributesRequest.setter(Builder::consistencyLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build()}).build();
    private static final SdkField<SchemaFacet> FACET_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FacetFilter").getter(ListObjectAttributesRequest.getter(ListObjectAttributesRequest::facetFilter)).setter(ListObjectAttributesRequest.setter(Builder::facetFilter)).constructor(SchemaFacet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, OBJECT_REFERENCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONSISTENCY_LEVEL_FIELD, FACET_FILTER_FIELD));
    private final String directoryArn;
    private final ObjectReference objectReference;
    private final String nextToken;
    private final Integer maxResults;
    private final String consistencyLevel;
    private final SchemaFacet facetFilter;

    private ListObjectAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
        this.facetFilter = builder.facetFilter;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public String consistencyLevelAsString() {
        return this.consistencyLevel;
    }

    public SchemaFacet facetFilter() {
        return this.facetFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetFilter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectAttributesRequest)) {
            return false;
        }
        ListObjectAttributesRequest other = (ListObjectAttributesRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.consistencyLevelAsString(), other.consistencyLevelAsString()) && Objects.equals(this.facetFilter(), other.facetFilter());
    }

    public String toString() {
        return ToString.builder((String)"ListObjectAttributesRequest").add("DirectoryArn", (Object)this.directoryArn()).add("ObjectReference", (Object)this.objectReference()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ConsistencyLevel", (Object)this.consistencyLevelAsString()).add("FacetFilter", (Object)this.facetFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ConsistencyLevel": {
                return Optional.ofNullable(clazz.cast(this.consistencyLevelAsString()));
            }
            case "FacetFilter": {
                return Optional.ofNullable(clazz.cast(this.facetFilter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectAttributesRequest, T> g) {
        return obj -> g.apply((ListObjectAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference objectReference;
        private String nextToken;
        private Integer maxResults;
        private String consistencyLevel;
        private SchemaFacet facetFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectAttributesRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.objectReference(model.objectReference);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.consistencyLevel(model.consistencyLevel);
            this.facetFilter(model.facetFilter);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        public final SchemaFacet.Builder getFacetFilter() {
            return this.facetFilter != null ? this.facetFilter.toBuilder() : null;
        }

        @Override
        public final Builder facetFilter(SchemaFacet facetFilter) {
            this.facetFilter = facetFilter;
            return this;
        }

        public final void setFacetFilter(SchemaFacet.BuilderImpl facetFilter) {
            this.facetFilter = facetFilter != null ? facetFilter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListObjectAttributesRequest build() {
            return new ListObjectAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObjectAttributesRequest> {
        public Builder directoryArn(String var1);

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);

        public Builder facetFilter(SchemaFacet var1);

        default public Builder facetFilter(Consumer<SchemaFacet.Builder> facetFilter) {
            return this.facetFilter((SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().applyMutation(facetFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

