/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdateListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateObjectAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchUpdateObjectAttributes> {
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ObjectReference").getter(BatchUpdateObjectAttributes.getter(BatchUpdateObjectAttributes::objectReference)).setter(BatchUpdateObjectAttributes.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final SdkField<List<ObjectAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeUpdates").getter(BatchUpdateObjectAttributes.getter(BatchUpdateObjectAttributes::attributeUpdates)).setter(BatchUpdateObjectAttributes.setter(Builder::attributeUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectAttributeUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_REFERENCE_FIELD, ATTRIBUTE_UPDATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final ObjectReference objectReference;
    private final List<ObjectAttributeUpdate> attributeUpdates;

    private BatchUpdateObjectAttributes(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.attributeUpdates = builder.attributeUpdates;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public boolean hasAttributeUpdates() {
        return this.attributeUpdates != null && !(this.attributeUpdates instanceof SdkAutoConstructList);
    }

    public List<ObjectAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeUpdates() ? this.attributeUpdates() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateObjectAttributes)) {
            return false;
        }
        BatchUpdateObjectAttributes other = (BatchUpdateObjectAttributes)obj;
        return Objects.equals(this.objectReference(), other.objectReference()) && this.hasAttributeUpdates() == other.hasAttributeUpdates() && Objects.equals(this.attributeUpdates(), other.attributeUpdates());
    }

    public String toString() {
        return ToString.builder((String)"BatchUpdateObjectAttributes").add("ObjectReference", (Object)this.objectReference()).add("AttributeUpdates", this.hasAttributeUpdates() ? this.attributeUpdates() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
            case "AttributeUpdates": {
                return Optional.ofNullable(clazz.cast(this.attributeUpdates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateObjectAttributes, T> g) {
        return obj -> g.apply((BatchUpdateObjectAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference objectReference;
        private List<ObjectAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateObjectAttributes model) {
            this.objectReference(model.objectReference);
            this.attributeUpdates(model.attributeUpdates);
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final Collection<ObjectAttributeUpdate.Builder> getAttributeUpdates() {
            if (this.attributeUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeUpdates != null ? (Collection)this.attributeUpdates.stream().map(ObjectAttributeUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(ObjectAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<ObjectAttributeUpdate.Builder> ... attributeUpdates) {
            this.attributeUpdates(Stream.of(attributeUpdates).map(c -> (ObjectAttributeUpdate)((ObjectAttributeUpdate.Builder)ObjectAttributeUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeUpdates(Collection<ObjectAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        public BatchUpdateObjectAttributes build() {
            return new BatchUpdateObjectAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchUpdateObjectAttributes> {
        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder attributeUpdates(Collection<ObjectAttributeUpdate> var1);

        public Builder attributeUpdates(ObjectAttributeUpdate ... var1);

        public Builder attributeUpdates(Consumer<ObjectAttributeUpdate.Builder> ... var1);
    }
}

