/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameTuple;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierToLinkNameMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectParentsResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListObjectParentsResponse> {
    private static final SdkField<Map<String, String>> PARENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parents").getter(ListObjectParentsResponse.getter(ListObjectParentsResponse::parents)).setter(ListObjectParentsResponse.setter(Builder::parents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parents").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListObjectParentsResponse.getter(ListObjectParentsResponse::nextToken)).setter(ListObjectParentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ObjectIdentifierAndLinkNameTuple>> PARENT_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParentLinks").getter(ListObjectParentsResponse.getter(ListObjectParentsResponse::parentLinks)).setter(ListObjectParentsResponse.setter(Builder::parentLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectIdentifierAndLinkNameTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENTS_FIELD, NEXT_TOKEN_FIELD, PARENT_LINKS_FIELD));
    private final Map<String, String> parents;
    private final String nextToken;
    private final List<ObjectIdentifierAndLinkNameTuple> parentLinks;

    private ListObjectParentsResponse(BuilderImpl builder) {
        super(builder);
        this.parents = builder.parents;
        this.nextToken = builder.nextToken;
        this.parentLinks = builder.parentLinks;
    }

    public boolean hasParents() {
        return this.parents != null && !(this.parents instanceof SdkAutoConstructMap);
    }

    public Map<String, String> parents() {
        return this.parents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasParentLinks() {
        return this.parentLinks != null && !(this.parentLinks instanceof SdkAutoConstructList);
    }

    public List<ObjectIdentifierAndLinkNameTuple> parentLinks() {
        return this.parentLinks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.parents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentLinks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectParentsResponse)) {
            return false;
        }
        ListObjectParentsResponse other = (ListObjectParentsResponse)((Object)obj);
        return Objects.equals(this.parents(), other.parents()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.parentLinks(), other.parentLinks());
    }

    public String toString() {
        return ToString.builder((String)"ListObjectParentsResponse").add("Parents", this.parents()).add("NextToken", (Object)this.nextToken()).add("ParentLinks", this.parentLinks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parents": {
                return Optional.ofNullable(clazz.cast(this.parents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ParentLinks": {
                return Optional.ofNullable(clazz.cast(this.parentLinks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectParentsResponse, T> g) {
        return obj -> g.apply((ListObjectParentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private Map<String, String> parents = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;
        private List<ObjectIdentifierAndLinkNameTuple> parentLinks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectParentsResponse model) {
            super(model);
            this.parents(model.parents);
            this.nextToken(model.nextToken);
            this.parentLinks(model.parentLinks);
        }

        public final Map<String, String> getParents() {
            return this.parents;
        }

        @Override
        public final Builder parents(Map<String, String> parents) {
            this.parents = ObjectIdentifierToLinkNameMapCopier.copy(parents);
            return this;
        }

        public final void setParents(Map<String, String> parents) {
            this.parents = ObjectIdentifierToLinkNameMapCopier.copy(parents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ObjectIdentifierAndLinkNameTuple.Builder> getParentLinks() {
            return this.parentLinks != null ? (Collection)this.parentLinks.stream().map(ObjectIdentifierAndLinkNameTuple::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parentLinks(Collection<ObjectIdentifierAndLinkNameTuple> parentLinks) {
            this.parentLinks = ObjectIdentifierAndLinkNameListCopier.copy(parentLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentLinks(ObjectIdentifierAndLinkNameTuple ... parentLinks) {
            this.parentLinks(Arrays.asList(parentLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentLinks(Consumer<ObjectIdentifierAndLinkNameTuple.Builder> ... parentLinks) {
            this.parentLinks(Stream.of(parentLinks).map(c -> (ObjectIdentifierAndLinkNameTuple)((ObjectIdentifierAndLinkNameTuple.Builder)ObjectIdentifierAndLinkNameTuple.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParentLinks(Collection<ObjectIdentifierAndLinkNameTuple.BuilderImpl> parentLinks) {
            this.parentLinks = ObjectIdentifierAndLinkNameListCopier.copyFromBuilder(parentLinks);
        }

        @Override
        public ListObjectParentsResponse build() {
            return new ListObjectParentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObjectParentsResponse> {
        public Builder parents(Map<String, String> var1);

        public Builder nextToken(String var1);

        public Builder parentLinks(Collection<ObjectIdentifierAndLinkNameTuple> var1);

        public Builder parentLinks(ObjectIdentifierAndLinkNameTuple ... var1);

        public Builder parentLinks(Consumer<ObjectIdentifierAndLinkNameTuple.Builder> ... var1);
    }
}

