/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRangeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListIncomingTypedLinks
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListIncomingTypedLinks> {
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchListIncomingTypedLinks.getter(BatchListIncomingTypedLinks::objectReference)).setter(BatchListIncomingTypedLinks.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final SdkField<List<TypedLinkAttributeRange>> FILTER_ATTRIBUTE_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchListIncomingTypedLinks.getter(BatchListIncomingTypedLinks::filterAttributeRanges)).setter(BatchListIncomingTypedLinks.setter(Builder::filterAttributeRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterAttributeRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypedLinkAttributeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TypedLinkSchemaAndFacetName> FILTER_TYPED_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchListIncomingTypedLinks.getter(BatchListIncomingTypedLinks::filterTypedLink)).setter(BatchListIncomingTypedLinks.setter(Builder::filterTypedLink)).constructor(TypedLinkSchemaAndFacetName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterTypedLink").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchListIncomingTypedLinks.getter(BatchListIncomingTypedLinks::nextToken)).setter(BatchListIncomingTypedLinks.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BatchListIncomingTypedLinks.getter(BatchListIncomingTypedLinks::maxResults)).setter(BatchListIncomingTypedLinks.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_REFERENCE_FIELD, FILTER_ATTRIBUTE_RANGES_FIELD, FILTER_TYPED_LINK_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ObjectReference objectReference;
    private final List<TypedLinkAttributeRange> filterAttributeRanges;
    private final TypedLinkSchemaAndFacetName filterTypedLink;
    private final String nextToken;
    private final Integer maxResults;

    private BatchListIncomingTypedLinks(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.filterAttributeRanges = builder.filterAttributeRanges;
        this.filterTypedLink = builder.filterTypedLink;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public List<TypedLinkAttributeRange> filterAttributeRanges() {
        return this.filterAttributeRanges;
    }

    public TypedLinkSchemaAndFacetName filterTypedLink() {
        return this.filterTypedLink;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterAttributeRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIncomingTypedLinks)) {
            return false;
        }
        BatchListIncomingTypedLinks other = (BatchListIncomingTypedLinks)obj;
        return Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.filterAttributeRanges(), other.filterAttributeRanges()) && Objects.equals(this.filterTypedLink(), other.filterTypedLink()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"BatchListIncomingTypedLinks").add("ObjectReference", (Object)this.objectReference()).add("FilterAttributeRanges", this.filterAttributeRanges()).add("FilterTypedLink", (Object)this.filterTypedLink()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
            case "FilterAttributeRanges": {
                return Optional.ofNullable(clazz.cast(this.filterAttributeRanges()));
            }
            case "FilterTypedLink": {
                return Optional.ofNullable(clazz.cast(this.filterTypedLink()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListIncomingTypedLinks, T> g) {
        return obj -> g.apply((BatchListIncomingTypedLinks)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference objectReference;
        private List<TypedLinkAttributeRange> filterAttributeRanges = DefaultSdkAutoConstructList.getInstance();
        private TypedLinkSchemaAndFacetName filterTypedLink;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListIncomingTypedLinks model) {
            this.objectReference(model.objectReference);
            this.filterAttributeRanges(model.filterAttributeRanges);
            this.filterTypedLink(model.filterTypedLink);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final Collection<TypedLinkAttributeRange.Builder> getFilterAttributeRanges() {
            return this.filterAttributeRanges != null ? (Collection)this.filterAttributeRanges.stream().map(TypedLinkAttributeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copy(filterAttributeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(TypedLinkAttributeRange ... filterAttributeRanges) {
            this.filterAttributeRanges(Arrays.asList(filterAttributeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(Consumer<TypedLinkAttributeRange.Builder> ... filterAttributeRanges) {
            this.filterAttributeRanges(Stream.of(filterAttributeRanges).map(c -> (TypedLinkAttributeRange)((TypedLinkAttributeRange.Builder)TypedLinkAttributeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilterAttributeRanges(Collection<TypedLinkAttributeRange.BuilderImpl> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copyFromBuilder(filterAttributeRanges);
        }

        public final TypedLinkSchemaAndFacetName.Builder getFilterTypedLink() {
            return this.filterTypedLink != null ? this.filterTypedLink.toBuilder() : null;
        }

        @Override
        public final Builder filterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
            this.filterTypedLink = filterTypedLink;
            return this;
        }

        public final void setFilterTypedLink(TypedLinkSchemaAndFacetName.BuilderImpl filterTypedLink) {
            this.filterTypedLink = filterTypedLink != null ? filterTypedLink.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public BatchListIncomingTypedLinks build() {
            return new BatchListIncomingTypedLinks(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListIncomingTypedLinks> {
        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> var1);

        public Builder filterAttributeRanges(TypedLinkAttributeRange ... var1);

        public Builder filterAttributeRanges(Consumer<TypedLinkAttributeRange.Builder> ... var1);

        public Builder filterTypedLink(TypedLinkSchemaAndFacetName var1);

        default public Builder filterTypedLink(Consumer<TypedLinkSchemaAndFacetName.Builder> filterTypedLink) {
            return this.filterTypedLink((TypedLinkSchemaAndFacetName)((TypedLinkSchemaAndFacetName.Builder)TypedLinkSchemaAndFacetName.builder().applyMutation(filterTypedLink)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

