/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse;

public class ListIndexIterable
implements SdkIterable<ListIndexResponse> {
    private final CloudDirectoryClient client;
    private final ListIndexRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIndexIterable(CloudDirectoryClient client, ListIndexRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIndexResponseFetcher();
    }

    public Iterator<ListIndexResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListIndexIterable resume(ListIndexResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListIndexIterable(this.client, (ListIndexRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListIndexIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListIndexResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListIndexResponseFetcher
    implements SyncPageFetcher<ListIndexResponse> {
        private ListIndexResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIndexResponse nextPage(ListIndexResponse previousPage) {
            if (previousPage == null) {
                return ListIndexIterable.this.client.listIndex(ListIndexIterable.this.firstRequest);
            }
            return ListIndexIterable.this.client.listIndex((ListIndexRequest)((Object)ListIndexIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

