/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;

public class TypedAttributeValueUnmarshaller
implements Unmarshaller<TypedAttributeValue, JsonUnmarshallerContext> {
    private static final TypedAttributeValueUnmarshaller INSTANCE = new TypedAttributeValueUnmarshaller();

    public TypedAttributeValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        TypedAttributeValue.Builder typedAttributeValueBuilder = TypedAttributeValue.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StringValue", targetDepth)) {
                    context.nextToken();
                    typedAttributeValueBuilder.stringValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BinaryValue", targetDepth)) {
                    context.nextToken();
                    typedAttributeValueBuilder.binaryValue((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("BooleanValue", targetDepth)) {
                    context.nextToken();
                    typedAttributeValueBuilder.booleanValue((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("NumberValue", targetDepth)) {
                    context.nextToken();
                    typedAttributeValueBuilder.numberValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DatetimeValue", targetDepth)) {
                    context.nextToken();
                    typedAttributeValueBuilder.datetimeValue((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TypedAttributeValue)typedAttributeValueBuilder.build();
    }

    public static TypedAttributeValueUnmarshaller getInstance() {
        return INSTANCE;
    }
}

