/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.nio.ByteBuffer;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TypedAttributeValueMarshaller {
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringValue").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> BINARYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BinaryValue").isBinary(false).build();
    private static final MarshallingInfo<Boolean> BOOLEANVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BooleanValue").isBinary(false).build();
    private static final MarshallingInfo<String> NUMBERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberValue").isBinary(false).build();
    private static final MarshallingInfo<Instant> DATETIMEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatetimeValue").isBinary(false).build();
    private static final TypedAttributeValueMarshaller INSTANCE = new TypedAttributeValueMarshaller();

    private TypedAttributeValueMarshaller() {
    }

    public static TypedAttributeValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TypedAttributeValue typedAttributeValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)typedAttributeValue, (String)"typedAttributeValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)typedAttributeValue.stringValue(), STRINGVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValue.binaryValue(), BINARYVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValue.booleanValue(), BOOLEANVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValue.numberValue(), NUMBERVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValue.datetimeValue(), DATETIMEVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

