/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PublishSchemaRequestModelMarshaller {
    private static final MarshallingInfo<String> DEVELOPMENTSCHEMAARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final PublishSchemaRequestModelMarshaller INSTANCE = new PublishSchemaRequestModelMarshaller();

    private PublishSchemaRequestModelMarshaller() {
    }

    public static PublishSchemaRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PublishSchemaRequest publishSchemaRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)publishSchemaRequest), (String)"publishSchemaRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)publishSchemaRequest.developmentSchemaArn(), DEVELOPMENTSCHEMAARN_BINDING);
            protocolMarshaller.marshall((Object)publishSchemaRequest.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)publishSchemaRequest.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

