/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.transform.AttributeKeyUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ObjectAttributeActionUnmarshaller;

public class ObjectAttributeUpdateUnmarshaller
implements Unmarshaller<ObjectAttributeUpdate, JsonUnmarshallerContext> {
    private static final ObjectAttributeUpdateUnmarshaller INSTANCE = new ObjectAttributeUpdateUnmarshaller();

    public ObjectAttributeUpdate unmarshall(JsonUnmarshallerContext context) throws Exception {
        ObjectAttributeUpdate.Builder objectAttributeUpdateBuilder = ObjectAttributeUpdate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ObjectAttributeKey", targetDepth)) {
                    context.nextToken();
                    objectAttributeUpdateBuilder.objectAttributeKey(AttributeKeyUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ObjectAttributeAction", targetDepth)) {
                    context.nextToken();
                    objectAttributeUpdateBuilder.objectAttributeAction(ObjectAttributeActionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ObjectAttributeUpdate)objectAttributeUpdateBuilder.build();
    }

    public static ObjectAttributeUpdateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

