/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ObjectAttributeRangeMarshaller {
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeKey").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Range").isBinary(false).build();
    private static final ObjectAttributeRangeMarshaller INSTANCE = new ObjectAttributeRangeMarshaller();

    private ObjectAttributeRangeMarshaller() {
    }

    public static ObjectAttributeRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ObjectAttributeRange objectAttributeRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)objectAttributeRange, (String)"objectAttributeRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)objectAttributeRange.attributeKey(), ATTRIBUTEKEY_BINDING);
            protocolMarshaller.marshall((Object)objectAttributeRange.range(), RANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

