/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListAttachedIndicesRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetReference").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> CONSISTENCYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-consistency-level").isBinary(false).build();
    private static final ListAttachedIndicesRequestModelMarshaller INSTANCE = new ListAttachedIndicesRequestModelMarshaller();

    private ListAttachedIndicesRequestModelMarshaller() {
    }

    public static ListAttachedIndicesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListAttachedIndicesRequest listAttachedIndicesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listAttachedIndicesRequest), (String)"listAttachedIndicesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listAttachedIndicesRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)listAttachedIndicesRequest.targetReference(), TARGETREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)listAttachedIndicesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listAttachedIndicesRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listAttachedIndicesRequest.consistencyLevelString(), CONSISTENCYLEVEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

