/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttribute;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FacetAttributeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeDefinition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeReference").isBinary(false).build();
    private static final MarshallingInfo<String> REQUIREDBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequiredBehavior").isBinary(false).build();
    private static final FacetAttributeMarshaller INSTANCE = new FacetAttributeMarshaller();

    private FacetAttributeMarshaller() {
    }

    public static FacetAttributeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FacetAttribute facetAttribute, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)facetAttribute, (String)"facetAttribute");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)facetAttribute.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)facetAttribute.attributeDefinition(), ATTRIBUTEDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)facetAttribute.attributeReference(), ATTRIBUTEREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)facetAttribute.requiredBehaviorString(), REQUIREDBEHAVIOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

