/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicyResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchLookupPolicyResponseMarshaller {
    private static final MarshallingInfo<List> POLICYTOPATHLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyToPathList").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final BatchLookupPolicyResponseMarshaller INSTANCE = new BatchLookupPolicyResponseMarshaller();

    private BatchLookupPolicyResponseMarshaller() {
    }

    public static BatchLookupPolicyResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchLookupPolicyResponse batchLookupPolicyResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchLookupPolicyResponse, (String)"batchLookupPolicyResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchLookupPolicyResponse.policyToPathList(), POLICYTOPATHLIST_BINDING);
            protocolMarshaller.marshall((Object)batchLookupPolicyResponse.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

