/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchListObjectAttributesMarshaller {
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FACETFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FacetFilter").isBinary(false).build();
    private static final BatchListObjectAttributesMarshaller INSTANCE = new BatchListObjectAttributesMarshaller();

    private BatchListObjectAttributesMarshaller() {
    }

    public static BatchListObjectAttributesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchListObjectAttributes batchListObjectAttributes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchListObjectAttributes, (String)"batchListObjectAttributes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchListObjectAttributes.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchListObjectAttributes.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)batchListObjectAttributes.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)batchListObjectAttributes.facetFilter(), FACETFILTER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

