/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformationResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchGetObjectInformationResponseMarshaller {
    private static final MarshallingInfo<List> SCHEMAFACETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaFacets").isBinary(false).build();
    private static final MarshallingInfo<String> OBJECTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectIdentifier").isBinary(false).build();
    private static final BatchGetObjectInformationResponseMarshaller INSTANCE = new BatchGetObjectInformationResponseMarshaller();

    private BatchGetObjectInformationResponseMarshaller() {
    }

    public static BatchGetObjectInformationResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetObjectInformationResponse batchGetObjectInformationResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchGetObjectInformationResponse, (String)"batchGetObjectInformationResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchGetObjectInformationResponse.schemaFacets(), SCHEMAFACETS_BINDING);
            protocolMarshaller.marshall((Object)batchGetObjectInformationResponse.objectIdentifier(), OBJECTIDENTIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

