/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchGetObjectInformationMarshaller {
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final BatchGetObjectInformationMarshaller INSTANCE = new BatchGetObjectInformationMarshaller();

    private BatchGetObjectInformationMarshaller() {
    }

    public static BatchGetObjectInformationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetObjectInformation batchGetObjectInformation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchGetObjectInformation, (String)"batchGetObjectInformation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchGetObjectInformation.objectReference(), OBJECTREFERENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

