/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttachPolicyRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> POLICYREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyReference").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final AttachPolicyRequestModelMarshaller INSTANCE = new AttachPolicyRequestModelMarshaller();

    private AttachPolicyRequestModelMarshaller() {
    }

    public static AttachPolicyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttachPolicyRequest attachPolicyRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)attachPolicyRequest), (String)"attachPolicyRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attachPolicyRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)attachPolicyRequest.policyReference(), POLICYREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)attachPolicyRequest.objectReference(), OBJECTREFERENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

