/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;

public class ListTypedLinkFacetNamesIterable
implements SdkIterable<ListTypedLinkFacetNamesResponse> {
    private final CloudDirectoryClient client;
    private final ListTypedLinkFacetNamesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTypedLinkFacetNamesIterable(CloudDirectoryClient client, ListTypedLinkFacetNamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTypedLinkFacetNamesResponseFetcher();
    }

    public Iterator<ListTypedLinkFacetNamesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListTypedLinkFacetNamesIterable resume(ListTypedLinkFacetNamesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTypedLinkFacetNamesIterable(this.client, (ListTypedLinkFacetNamesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTypedLinkFacetNamesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTypedLinkFacetNamesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTypedLinkFacetNamesResponseFetcher
    implements SyncPageFetcher<ListTypedLinkFacetNamesResponse> {
        private ListTypedLinkFacetNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypedLinkFacetNamesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTypedLinkFacetNamesResponse nextPage(ListTypedLinkFacetNamesResponse previousPage) {
            if (previousPage == null) {
                return ListTypedLinkFacetNamesIterable.this.client.listTypedLinkFacetNames(ListTypedLinkFacetNamesIterable.this.firstRequest);
            }
            return ListTypedLinkFacetNamesIterable.this.client.listTypedLinkFacetNames((ListTypedLinkFacetNamesRequest)((Object)ListTypedLinkFacetNamesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

