/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse;

public class ListObjectParentsPublisher
implements SdkPublisher<ListObjectParentsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListObjectParentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectParentsPublisher(CloudDirectoryAsyncClient client, ListObjectParentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectParentsPublisher(CloudDirectoryAsyncClient client, ListObjectParentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectParentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectParentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListObjectParentsPublisher resume(ListObjectParentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListObjectParentsPublisher(this.client, (ListObjectParentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListObjectParentsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListObjectParentsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListObjectParentsResponseFetcher
    implements AsyncPageFetcher<ListObjectParentsResponse> {
        private ListObjectParentsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectParentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListObjectParentsResponse> nextPage(ListObjectParentsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectParentsPublisher.this.client.listObjectParents(ListObjectParentsPublisher.this.firstRequest);
            }
            return ListObjectParentsPublisher.this.client.listObjectParents((ListObjectParentsRequest)((Object)ListObjectParentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

