/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;

public class ListObjectAttributesPublisher
implements SdkPublisher<ListObjectAttributesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListObjectAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectAttributesPublisher(CloudDirectoryAsyncClient client, ListObjectAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectAttributesPublisher(CloudDirectoryAsyncClient client, ListObjectAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListObjectAttributesPublisher resume(ListObjectAttributesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListObjectAttributesPublisher(this.client, (ListObjectAttributesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListObjectAttributesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListObjectAttributesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListObjectAttributesResponseFetcher
    implements AsyncPageFetcher<ListObjectAttributesResponse> {
        private ListObjectAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectAttributesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListObjectAttributesResponse> nextPage(ListObjectAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectAttributesPublisher.this.client.listObjectAttributes(ListObjectAttributesPublisher.this.firstRequest);
            }
            return ListObjectAttributesPublisher.this.client.listObjectAttributes((ListObjectAttributesRequest)((Object)ListObjectAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

