/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTypedLinkFacetRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, UpdateTypedLinkFacetRequest> {
    private final String schemaArn;
    private final String name;
    private final List<TypedLinkFacetAttributeUpdate> attributeUpdates;
    private final List<String> identityAttributeOrder;

    private UpdateTypedLinkFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributeUpdates = builder.attributeUpdates;
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String name() {
        return this.name;
    }

    public List<TypedLinkFacetAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public List<String> identityAttributeOrder() {
        return this.identityAttributeOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityAttributeOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTypedLinkFacetRequest)) {
            return false;
        }
        UpdateTypedLinkFacetRequest other = (UpdateTypedLinkFacetRequest)((Object)obj);
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.attributeUpdates(), other.attributeUpdates()) && Objects.equals(this.identityAttributeOrder(), other.identityAttributeOrder());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTypedLinkFacetRequest").add("SchemaArn", (Object)this.schemaArn()).add("Name", (Object)this.name()).add("AttributeUpdates", this.attributeUpdates()).add("IdentityAttributeOrder", this.identityAttributeOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.of(clazz.cast(this.schemaArn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "AttributeUpdates": {
                return Optional.of(clazz.cast(this.attributeUpdates()));
            }
            case "IdentityAttributeOrder": {
                return Optional.of(clazz.cast(this.identityAttributeOrder()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String schemaArn;
        private String name;
        private List<TypedLinkFacetAttributeUpdate> attributeUpdates;
        private List<String> identityAttributeOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTypedLinkFacetRequest model) {
            this.schemaArn(model.schemaArn);
            this.name(model.name);
            this.attributeUpdates(model.attributeUpdates);
            this.identityAttributeOrder(model.identityAttributeOrder);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TypedLinkFacetAttributeUpdate.Builder> getAttributeUpdates() {
            return this.attributeUpdates != null ? (Collection)this.attributeUpdates.stream().map(TypedLinkFacetAttributeUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeUpdates(Collection<TypedLinkFacetAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = TypedLinkFacetAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(TypedLinkFacetAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        public final void setAttributeUpdates(Collection<TypedLinkFacetAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = TypedLinkFacetAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        public final Collection<String> getIdentityAttributeOrder() {
            return this.identityAttributeOrder;
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String ... identityAttributeOrder) {
            this.identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateTypedLinkFacetRequest build() {
            return new UpdateTypedLinkFacetRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, UpdateTypedLinkFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder name(String var1);

        public Builder attributeUpdates(Collection<TypedLinkFacetAttributeUpdate> var1);

        public Builder attributeUpdates(TypedLinkFacetAttributeUpdate ... var1);

        public Builder identityAttributeOrder(Collection<String> var1);

        public Builder identityAttributeOrder(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

