/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinitionListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.TypedLinkFacetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TypedLinkFacet
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedLinkFacet> {
    private final String name;
    private final List<TypedLinkAttributeDefinition> attributes;
    private final List<String> identityAttributeOrder;

    private TypedLinkFacet(BuilderImpl builder) {
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    public String name() {
        return this.name;
    }

    public List<TypedLinkAttributeDefinition> attributes() {
        return this.attributes;
    }

    public List<String> identityAttributeOrder() {
        return this.identityAttributeOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityAttributeOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkFacet)) {
            return false;
        }
        TypedLinkFacet other = (TypedLinkFacet)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.identityAttributeOrder(), other.identityAttributeOrder());
    }

    public String toString() {
        return ToString.builder((String)"TypedLinkFacet").add("Name", (Object)this.name()).add("Attributes", this.attributes()).add("IdentityAttributeOrder", this.identityAttributeOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "IdentityAttributeOrder": {
                return Optional.of(clazz.cast(this.identityAttributeOrder()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkFacetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<TypedLinkAttributeDefinition> attributes;
        private List<String> identityAttributeOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkFacet model) {
            this.name(model.name);
            this.attributes(model.attributes);
            this.identityAttributeOrder(model.identityAttributeOrder);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TypedLinkAttributeDefinition.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(TypedLinkAttributeDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<TypedLinkAttributeDefinition> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TypedLinkAttributeDefinition ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<TypedLinkAttributeDefinition.BuilderImpl> attributes) {
            this.attributes = TypedLinkAttributeDefinitionListCopier.copyFromBuilder(attributes);
        }

        public final Collection<String> getIdentityAttributeOrder() {
            return this.identityAttributeOrder;
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String ... identityAttributeOrder) {
            this.identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        public TypedLinkFacet build() {
            return new TypedLinkFacet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedLinkFacet> {
        public Builder name(String var1);

        public Builder attributes(Collection<TypedLinkAttributeDefinition> var1);

        public Builder attributes(TypedLinkAttributeDefinition ... var1);

        public Builder identityAttributeOrder(Collection<String> var1);

        public Builder identityAttributeOrder(String ... var1);
    }
}

