/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValueRange;
import software.amazon.awssdk.services.clouddirectory.transform.ObjectAttributeRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ObjectAttributeRange
implements StructuredPojo,
ToCopyableBuilder<Builder, ObjectAttributeRange> {
    private final AttributeKey attributeKey;
    private final TypedAttributeValueRange range;

    private ObjectAttributeRange(BuilderImpl builder) {
        this.attributeKey = builder.attributeKey;
        this.range = builder.range;
    }

    public AttributeKey attributeKey() {
        return this.attributeKey;
    }

    public TypedAttributeValueRange range() {
        return this.range;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.range());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectAttributeRange)) {
            return false;
        }
        ObjectAttributeRange other = (ObjectAttributeRange)obj;
        return Objects.equals(this.attributeKey(), other.attributeKey()) && Objects.equals(this.range(), other.range());
    }

    public String toString() {
        return ToString.builder((String)"ObjectAttributeRange").add("AttributeKey", (Object)this.attributeKey()).add("Range", (Object)this.range()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeKey": {
                return Optional.of(clazz.cast(this.attributeKey()));
            }
            case "Range": {
                return Optional.of(clazz.cast(this.range()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ObjectAttributeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeKey attributeKey;
        private TypedAttributeValueRange range;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectAttributeRange model) {
            this.attributeKey(model.attributeKey);
            this.range(model.range);
        }

        public final AttributeKey.Builder getAttributeKey() {
            return this.attributeKey != null ? this.attributeKey.toBuilder() : null;
        }

        @Override
        public final Builder attributeKey(AttributeKey attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        public final void setAttributeKey(AttributeKey.BuilderImpl attributeKey) {
            this.attributeKey = attributeKey != null ? attributeKey.build() : null;
        }

        public final TypedAttributeValueRange.Builder getRange() {
            return this.range != null ? this.range.toBuilder() : null;
        }

        @Override
        public final Builder range(TypedAttributeValueRange range) {
            this.range = range;
            return this;
        }

        public final void setRange(TypedAttributeValueRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        public ObjectAttributeRange build() {
            return new ObjectAttributeRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ObjectAttributeRange> {
        public Builder attributeKey(AttributeKey var1);

        default public Builder attributeKey(Consumer<AttributeKey.Builder> attributeKey) {
            return this.attributeKey((AttributeKey)((AttributeKey.Builder)AttributeKey.builder().apply(attributeKey)).build());
        }

        public Builder range(TypedAttributeValueRange var1);

        default public Builder range(Consumer<TypedAttributeValueRange.Builder> range) {
            return this.range((TypedAttributeValueRange)((TypedAttributeValueRange.Builder)TypedAttributeValueRange.builder().apply(range)).build());
        }
    }
}

