/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachPolicyRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, AttachPolicyRequest> {
    private final String directoryArn;
    private final ObjectReference policyReference;
    private final ObjectReference objectReference;

    private AttachPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.policyReference = builder.policyReference;
        this.objectReference = builder.objectReference;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference policyReference() {
        return this.policyReference;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachPolicyRequest)) {
            return false;
        }
        AttachPolicyRequest other = (AttachPolicyRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.policyReference(), other.policyReference()) && Objects.equals(this.objectReference(), other.objectReference());
    }

    public String toString() {
        return ToString.builder((String)"AttachPolicyRequest").add("DirectoryArn", (Object)this.directoryArn()).add("PolicyReference", (Object)this.policyReference()).add("ObjectReference", (Object)this.objectReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "PolicyReference": {
                return Optional.of(clazz.cast(this.policyReference()));
            }
            case "ObjectReference": {
                return Optional.of(clazz.cast(this.objectReference()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference policyReference;
        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachPolicyRequest model) {
            this.directoryArn(model.directoryArn);
            this.policyReference(model.policyReference);
            this.objectReference(model.objectReference);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getPolicyReference() {
            return this.policyReference != null ? this.policyReference.toBuilder() : null;
        }

        @Override
        public final Builder policyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
            return this;
        }

        public final void setPolicyReference(ObjectReference.BuilderImpl policyReference) {
            this.policyReference = policyReference != null ? policyReference.build() : null;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachPolicyRequest build() {
            return new AttachPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, AttachPolicyRequest> {
        public Builder directoryArn(String var1);

        public Builder policyReference(ObjectReference var1);

        default public Builder policyReference(Consumer<ObjectReference.Builder> policyReference) {
            return this.policyReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(policyReference)).build());
        }

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(objectReference)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

