/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse;

public final class ListFacetNamesPaginator
implements SdkIterable<ListFacetNamesResponse> {
    private final CloudDirectoryClient client;
    private final ListFacetNamesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListFacetNamesPaginator(CloudDirectoryClient client, ListFacetNamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFacetNamesResponseFetcher();
    }

    public Iterator<ListFacetNamesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListFacetNamesResponseFetcher
    implements NextPageFetcher<ListFacetNamesResponse> {
        private ListFacetNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacetNamesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListFacetNamesResponse nextPage(ListFacetNamesResponse previousPage) {
            if (previousPage == null) {
                return ListFacetNamesPaginator.this.client.listFacetNames(ListFacetNamesPaginator.this.firstRequest);
            }
            return ListFacetNamesPaginator.this.client.listFacetNames((ListFacetNamesRequest)((Object)ListFacetNamesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

