/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdateListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateObjectAttributesRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, UpdateObjectAttributesRequest> {
    private final String directoryArn;
    private final ObjectReference objectReference;
    private final List<ObjectAttributeUpdate> attributeUpdates;

    private UpdateObjectAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.attributeUpdates = builder.attributeUpdates;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public List<ObjectAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateObjectAttributesRequest)) {
            return false;
        }
        UpdateObjectAttributesRequest other = (UpdateObjectAttributesRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.attributeUpdates(), other.attributeUpdates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateObjectAttributesRequest").add("DirectoryArn", (Object)this.directoryArn()).add("ObjectReference", (Object)this.objectReference()).add("AttributeUpdates", this.attributeUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "ObjectReference": {
                return Optional.of(clazz.cast(this.objectReference()));
            }
            case "AttributeUpdates": {
                return Optional.of(clazz.cast(this.attributeUpdates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference objectReference;
        private List<ObjectAttributeUpdate> attributeUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateObjectAttributesRequest model) {
            this.directoryArn(model.directoryArn);
            this.objectReference(model.objectReference);
            this.attributeUpdates(model.attributeUpdates);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final Collection<ObjectAttributeUpdate.Builder> getAttributeUpdates() {
            return this.attributeUpdates != null ? (Collection)this.attributeUpdates.stream().map(ObjectAttributeUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(ObjectAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        public final void setAttributeUpdates(Collection<ObjectAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateObjectAttributesRequest build() {
            return new UpdateObjectAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, UpdateObjectAttributesRequest> {
        public Builder directoryArn(String var1);

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(objectReference)).build());
        }

        public Builder attributeUpdates(Collection<ObjectAttributeUpdate> var1);

        public Builder attributeUpdates(ObjectAttributeUpdate ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

