/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.Directory;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDirectoriesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListDirectoriesResponse> {
    private final List<Directory> directories;
    private final String nextToken;

    private ListDirectoriesResponse(BuilderImpl builder) {
        super(builder);
        this.directories = builder.directories;
        this.nextToken = builder.nextToken;
    }

    public List<Directory> directories() {
        return this.directories;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directories());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectoriesResponse)) {
            return false;
        }
        ListDirectoriesResponse other = (ListDirectoriesResponse)((Object)obj);
        return Objects.equals(this.directories(), other.directories()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDirectoriesResponse").add("Directories", this.directories()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Directories": {
                return Optional.of(clazz.cast(this.directories()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<Directory> directories;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDirectoriesResponse model) {
            this.directories(model.directories);
            this.nextToken(model.nextToken);
        }

        public final Collection<Directory.Builder> getDirectories() {
            return this.directories != null ? (Collection)this.directories.stream().map(Directory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directories(Collection<Directory> directories) {
            this.directories = DirectoryListCopier.copy(directories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directories(Directory ... directories) {
            this.directories(Arrays.asList(directories));
            return this;
        }

        public final void setDirectories(Collection<Directory.BuilderImpl> directories) {
            this.directories = DirectoryListCopier.copyFromBuilder(directories);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDirectoriesResponse build() {
            return new ListDirectoriesResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListDirectoriesResponse> {
        public Builder directories(Collection<Directory> var1);

        public Builder directories(Directory ... var1);

        public Builder nextToken(String var1);
    }
}

