/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateIndexRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, CreateIndexRequest> {
    private final String directoryArn;
    private final List<AttributeKey> orderedIndexedAttributeList;
    private final Boolean isUnique;
    private final ObjectReference parentReference;
    private final String linkName;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.orderedIndexedAttributeList = builder.orderedIndexedAttributeList;
        this.isUnique = builder.isUnique;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public List<AttributeKey> orderedIndexedAttributeList() {
        return this.orderedIndexedAttributeList;
    }

    public Boolean isUnique() {
        return this.isUnique;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderedIndexedAttributeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.isUnique());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.orderedIndexedAttributeList(), other.orderedIndexedAttributeList()) && Objects.equals(this.isUnique(), other.isUnique()) && Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.linkName(), other.linkName());
    }

    public String toString() {
        return ToString.builder((String)"CreateIndexRequest").add("DirectoryArn", (Object)this.directoryArn()).add("OrderedIndexedAttributeList", this.orderedIndexedAttributeList()).add("IsUnique", (Object)this.isUnique()).add("ParentReference", (Object)this.parentReference()).add("LinkName", (Object)this.linkName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "OrderedIndexedAttributeList": {
                return Optional.of(clazz.cast(this.orderedIndexedAttributeList()));
            }
            case "IsUnique": {
                return Optional.of(clazz.cast(this.isUnique()));
            }
            case "ParentReference": {
                return Optional.of(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.of(clazz.cast(this.linkName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<AttributeKey> orderedIndexedAttributeList;
        private Boolean isUnique;
        private ObjectReference parentReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            this.directoryArn(model.directoryArn);
            this.orderedIndexedAttributeList(model.orderedIndexedAttributeList);
            this.isUnique(model.isUnique);
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<AttributeKey.Builder> getOrderedIndexedAttributeList() {
            return this.orderedIndexedAttributeList != null ? (Collection)this.orderedIndexedAttributeList.stream().map(AttributeKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copy(orderedIndexedAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(AttributeKey ... orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList(Arrays.asList(orderedIndexedAttributeList));
            return this;
        }

        public final void setOrderedIndexedAttributeList(Collection<AttributeKey.BuilderImpl> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copyFromBuilder(orderedIndexedAttributeList);
        }

        public final Boolean getIsUnique() {
            return this.isUnique;
        }

        @Override
        public final Builder isUnique(Boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public final void setIsUnique(Boolean isUnique) {
            this.isUnique = isUnique;
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, CreateIndexRequest> {
        public Builder directoryArn(String var1);

        public Builder orderedIndexedAttributeList(Collection<AttributeKey> var1);

        public Builder orderedIndexedAttributeList(AttributeKey ... var1);

        public Builder isUnique(Boolean var1);

        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(parentReference)).build());
        }

        public Builder linkName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

