/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse;

public final class ListIndexPaginator
implements SdkIterable<ListIndexResponse> {
    private final CloudDirectoryClient client;
    private final ListIndexRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListIndexPaginator(CloudDirectoryClient client, ListIndexRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIndexResponseFetcher();
    }

    public Iterator<ListIndexResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListIndexResponseFetcher
    implements NextPageFetcher<ListIndexResponse> {
        private ListIndexResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListIndexResponse nextPage(ListIndexResponse previousPage) {
            if (previousPage == null) {
                return ListIndexPaginator.this.client.listIndex(ListIndexPaginator.this.firstRequest);
            }
            return ListIndexPaginator.this.client.listIndex((ListIndexRequest)((Object)ListIndexPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

