/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.UpdateActionType;
import software.amazon.awssdk.services.clouddirectory.transform.TypedLinkFacetAttributeUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TypedLinkFacetAttributeUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedLinkFacetAttributeUpdate> {
    private final TypedLinkAttributeDefinition attribute;
    private final String action;

    private TypedLinkFacetAttributeUpdate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.action = builder.action;
    }

    public TypedLinkAttributeDefinition attribute() {
        return this.attribute;
    }

    public UpdateActionType action() {
        return UpdateActionType.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkFacetAttributeUpdate)) {
            return false;
        }
        TypedLinkFacetAttributeUpdate other = (TypedLinkFacetAttributeUpdate)obj;
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.actionString(), other.actionString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attribute() != null) {
            sb.append("Attribute: ").append(this.attribute()).append(",");
        }
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.of(clazz.cast(this.attribute()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkFacetAttributeUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private TypedLinkAttributeDefinition attribute;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkFacetAttributeUpdate model) {
            this.attribute(model.attribute);
            this.action(model.action);
        }

        public final TypedLinkAttributeDefinition.Builder getAttribute() {
            return this.attribute != null ? this.attribute.toBuilder() : null;
        }

        @Override
        public final Builder attribute(TypedLinkAttributeDefinition attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(TypedLinkAttributeDefinition.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateActionType action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public TypedLinkFacetAttributeUpdate build() {
            return new TypedLinkFacetAttributeUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedLinkFacetAttributeUpdate> {
        public Builder attribute(TypedLinkAttributeDefinition var1);

        default public Builder attribute(Consumer<TypedLinkAttributeDefinition.Builder> attribute) {
            return this.attribute((TypedLinkAttributeDefinition)((TypedLinkAttributeDefinition.Builder)TypedLinkAttributeDefinition.builder().apply(attribute)).build());
        }

        public Builder action(String var1);

        public Builder action(UpdateActionType var1);
    }
}

