/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadException;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse;
import software.amazon.awssdk.services.clouddirectory.transform.BatchReadOperationResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchReadOperationResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchReadOperationResponse> {
    private final BatchReadSuccessfulResponse successfulResponse;
    private final BatchReadException exceptionResponse;

    private BatchReadOperationResponse(BuilderImpl builder) {
        this.successfulResponse = builder.successfulResponse;
        this.exceptionResponse = builder.exceptionResponse;
    }

    public BatchReadSuccessfulResponse successfulResponse() {
        return this.successfulResponse;
    }

    public BatchReadException exceptionResponse() {
        return this.exceptionResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successfulResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.exceptionResponse());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadOperationResponse)) {
            return false;
        }
        BatchReadOperationResponse other = (BatchReadOperationResponse)obj;
        return Objects.equals(this.successfulResponse(), other.successfulResponse()) && Objects.equals(this.exceptionResponse(), other.exceptionResponse());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.successfulResponse() != null) {
            sb.append("SuccessfulResponse: ").append(this.successfulResponse()).append(",");
        }
        if (this.exceptionResponse() != null) {
            sb.append("ExceptionResponse: ").append(this.exceptionResponse()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulResponse": {
                return Optional.of(clazz.cast(this.successfulResponse()));
            }
            case "ExceptionResponse": {
                return Optional.of(clazz.cast(this.exceptionResponse()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchReadOperationResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchReadSuccessfulResponse successfulResponse;
        private BatchReadException exceptionResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadOperationResponse model) {
            this.successfulResponse(model.successfulResponse);
            this.exceptionResponse(model.exceptionResponse);
        }

        public final BatchReadSuccessfulResponse.Builder getSuccessfulResponse() {
            return this.successfulResponse != null ? this.successfulResponse.toBuilder() : null;
        }

        @Override
        public final Builder successfulResponse(BatchReadSuccessfulResponse successfulResponse) {
            this.successfulResponse = successfulResponse;
            return this;
        }

        public final void setSuccessfulResponse(BatchReadSuccessfulResponse.BuilderImpl successfulResponse) {
            this.successfulResponse = successfulResponse != null ? successfulResponse.build() : null;
        }

        public final BatchReadException.Builder getExceptionResponse() {
            return this.exceptionResponse != null ? this.exceptionResponse.toBuilder() : null;
        }

        @Override
        public final Builder exceptionResponse(BatchReadException exceptionResponse) {
            this.exceptionResponse = exceptionResponse;
            return this;
        }

        public final void setExceptionResponse(BatchReadException.BuilderImpl exceptionResponse) {
            this.exceptionResponse = exceptionResponse != null ? exceptionResponse.build() : null;
        }

        public BatchReadOperationResponse build() {
            return new BatchReadOperationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchReadOperationResponse> {
        public Builder successfulResponse(BatchReadSuccessfulResponse var1);

        default public Builder successfulResponse(Consumer<BatchReadSuccessfulResponse.Builder> successfulResponse) {
            return this.successfulResponse((BatchReadSuccessfulResponse)((BatchReadSuccessfulResponse.Builder)BatchReadSuccessfulResponse.builder().apply(successfulResponse)).build());
        }

        public Builder exceptionResponse(BatchReadException var1);

        default public Builder exceptionResponse(Consumer<BatchReadException.Builder> exceptionResponse) {
            return this.exceptionResponse((BatchReadException)((BatchReadException.Builder)BatchReadException.builder().apply(exceptionResponse)).build());
        }
    }
}

