/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.PolicyToPath;

@SdkInternalApi
public class PolicyToPathMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").build();
    private static final MarshallingInfo<List> POLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policies").build();
    private static final PolicyToPathMarshaller INSTANCE = new PolicyToPathMarshaller();

    public static PolicyToPathMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyToPath policyToPath, ProtocolMarshaller protocolMarshaller) {
        if (policyToPath == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)policyToPath.path(), PATH_BINDING);
            protocolMarshaller.marshall(policyToPath.policies(), POLICIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

