/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest;

@SdkInternalApi
public class GetObjectInformationRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").build();
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").build();
    private static final MarshallingInfo<String> CONSISTENCYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-consistency-level").build();
    private static final GetObjectInformationRequestModelMarshaller INSTANCE = new GetObjectInformationRequestModelMarshaller();

    public static GetObjectInformationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetObjectInformationRequest getObjectInformationRequest, ProtocolMarshaller protocolMarshaller) {
        if (getObjectInformationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)getObjectInformationRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)getObjectInformationRequest.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)getObjectInformationRequest.consistencyLevelString(), CONSISTENCYLEVEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

