/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest;

@SdkInternalApi
public class AttachTypedLinkRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").build();
    private static final MarshallingInfo<StructuredPojo> SOURCEOBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceObjectReference").build();
    private static final MarshallingInfo<StructuredPojo> TARGETOBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetObjectReference").build();
    private static final MarshallingInfo<StructuredPojo> TYPEDLINKFACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypedLinkFacet").build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").build();
    private static final AttachTypedLinkRequestModelMarshaller INSTANCE = new AttachTypedLinkRequestModelMarshaller();

    public static AttachTypedLinkRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttachTypedLinkRequest attachTypedLinkRequest, ProtocolMarshaller protocolMarshaller) {
        if (attachTypedLinkRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)attachTypedLinkRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)attachTypedLinkRequest.sourceObjectReference(), SOURCEOBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)attachTypedLinkRequest.targetObjectReference(), TARGETOBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)attachTypedLinkRequest.typedLinkFacet(), TYPEDLINKFACET_BINDING);
            protocolMarshaller.marshall(attachTypedLinkRequest.attributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

