/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse;

public final class ListTagsForResourcePaginator
implements SdkIterable<ListTagsForResourceResponse> {
    private final CloudDirectoryClient client;
    private final ListTagsForResourceRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTagsForResourcePaginator(CloudDirectoryClient client, ListTagsForResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsForResourceResponseFetcher();
    }

    public Iterator<ListTagsForResourceResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListTagsForResourceResponseFetcher
    implements NextPageFetcher<ListTagsForResourceResponse> {
        private ListTagsForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsForResourceResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTagsForResourceResponse nextPage(ListTagsForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListTagsForResourcePaginator.this.client.listTagsForResource(ListTagsForResourcePaginator.this.firstRequest);
            }
            return ListTagsForResourcePaginator.this.client.listTagsForResource((ListTagsForResourceRequest)((Object)ListTagsForResourcePaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

