/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse;

public final class ListObjectPoliciesPaginator
implements SdkIterable<ListObjectPoliciesResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectPoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListObjectPoliciesPaginator(CloudDirectoryClient client, ListObjectPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectPoliciesResponseFetcher();
    }

    public Iterator<ListObjectPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListObjectPoliciesResponseFetcher
    implements NextPageFetcher<ListObjectPoliciesResponse> {
        private ListObjectPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectPoliciesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListObjectPoliciesResponse nextPage(ListObjectPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectPoliciesPaginator.this.client.listObjectPolicies(ListObjectPoliciesPaginator.this.firstRequest);
            }
            return ListObjectPoliciesPaginator.this.client.listObjectPolicies((ListObjectPoliciesRequest)((Object)ListObjectPoliciesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

