/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PublishSchemaRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PublishSchemaRequest> {
    private final String developmentSchemaArn;
    private final String version;
    private final String name;

    private PublishSchemaRequest(BuilderImpl builder) {
        this.developmentSchemaArn = builder.developmentSchemaArn;
        this.version = builder.version;
        this.name = builder.name;
    }

    public String developmentSchemaArn() {
        return this.developmentSchemaArn;
    }

    public String version() {
        return this.version;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.developmentSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishSchemaRequest)) {
            return false;
        }
        PublishSchemaRequest other = (PublishSchemaRequest)((Object)obj);
        return Objects.equals(this.developmentSchemaArn(), other.developmentSchemaArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.developmentSchemaArn() != null) {
            sb.append("DevelopmentSchemaArn: ").append(this.developmentSchemaArn()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevelopmentSchemaArn": {
                return Optional.of(clazz.cast(this.developmentSchemaArn()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String developmentSchemaArn;
        private String version;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishSchemaRequest model) {
            this.developmentSchemaArn(model.developmentSchemaArn);
            this.version(model.version);
            this.name(model.name);
        }

        public final String getDevelopmentSchemaArn() {
            return this.developmentSchemaArn;
        }

        @Override
        public final Builder developmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
            return this;
        }

        public final void setDevelopmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public PublishSchemaRequest build() {
            return new PublishSchemaRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PublishSchemaRequest> {
        public Builder developmentSchemaArn(String var1);

        public Builder version(String var1);

        public Builder name(String var1);
    }
}

