/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment;
import software.amazon.awssdk.services.clouddirectory.model.PolicyAttachmentListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.PolicyToPathMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyToPath
implements StructuredPojo,
ToCopyableBuilder<Builder, PolicyToPath> {
    private final String path;
    private final List<PolicyAttachment> policies;

    private PolicyToPath(BuilderImpl builder) {
        this.path = builder.path;
        this.policies = builder.policies;
    }

    public String path() {
        return this.path;
    }

    public List<PolicyAttachment> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyToPath)) {
            return false;
        }
        PolicyToPath other = (PolicyToPath)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.policies(), other.policies());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.policies() != null) {
            sb.append("Policies: ").append(this.policies()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "Policies": {
                return Optional.of(clazz.cast(this.policies()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyToPathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private List<PolicyAttachment> policies;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyToPath model) {
            this.path(model.path);
            this.policies(model.policies);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<PolicyAttachment.Builder> getPolicies() {
            return this.policies != null ? (Collection)this.policies.stream().map(PolicyAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<PolicyAttachment> policies) {
            this.policies = PolicyAttachmentListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyAttachment ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        public final void setPolicies(Collection<PolicyAttachment.BuilderImpl> policies) {
            this.policies = PolicyAttachmentListCopier.copyFromBuilder(policies);
        }

        public PolicyToPath build() {
            return new PolicyToPath(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyToPath> {
        public Builder path(String var1);

        public Builder policies(Collection<PolicyAttachment> var1);

        public Builder policies(PolicyAttachment ... var1);
    }
}

