/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPolicyAttachmentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPolicyAttachmentsResponse> {
    private final List<String> objectIdentifiers;
    private final String nextToken;

    private ListPolicyAttachmentsResponse(BuilderImpl builder) {
        this.objectIdentifiers = builder.objectIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public List<String> objectIdentifiers() {
        return this.objectIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyAttachmentsResponse)) {
            return false;
        }
        ListPolicyAttachmentsResponse other = (ListPolicyAttachmentsResponse)((Object)obj);
        return Objects.equals(this.objectIdentifiers(), other.objectIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.objectIdentifiers() != null) {
            sb.append("ObjectIdentifiers: ").append(this.objectIdentifiers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectIdentifiers": {
                return Optional.of(clazz.cast(this.objectIdentifiers()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> objectIdentifiers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyAttachmentsResponse model) {
            this.objectIdentifiers(model.objectIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getObjectIdentifiers() {
            return this.objectIdentifiers;
        }

        @Override
        public final Builder objectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIdentifiers(String ... objectIdentifiers) {
            this.objectIdentifiers(Arrays.asList(objectIdentifiers));
            return this;
        }

        public final void setObjectIdentifiers(Collection<String> objectIdentifiers) {
            this.objectIdentifiers = ObjectIdentifierListCopier.copy(objectIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPolicyAttachmentsResponse build() {
            return new ListPolicyAttachmentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPolicyAttachmentsResponse> {
        public Builder objectIdentifiers(Collection<String> var1);

        public Builder objectIdentifiers(String ... var1);

        public Builder nextToken(String var1);
    }
}

