/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOutgoingTypedLinksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListOutgoingTypedLinksResponse> {
    private final List<TypedLinkSpecifier> typedLinkSpecifiers;
    private final String nextToken;

    private ListOutgoingTypedLinksResponse(BuilderImpl builder) {
        this.typedLinkSpecifiers = builder.typedLinkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    public List<TypedLinkSpecifier> typedLinkSpecifiers() {
        return this.typedLinkSpecifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkSpecifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingTypedLinksResponse)) {
            return false;
        }
        ListOutgoingTypedLinksResponse other = (ListOutgoingTypedLinksResponse)((Object)obj);
        return Objects.equals(this.typedLinkSpecifiers(), other.typedLinkSpecifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typedLinkSpecifiers() != null) {
            sb.append("TypedLinkSpecifiers: ").append(this.typedLinkSpecifiers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypedLinkSpecifiers": {
                return Optional.of(clazz.cast(this.typedLinkSpecifiers()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TypedLinkSpecifier> typedLinkSpecifiers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingTypedLinksResponse model) {
            this.typedLinkSpecifiers(model.typedLinkSpecifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<TypedLinkSpecifier.Builder> getTypedLinkSpecifiers() {
            return this.typedLinkSpecifiers != null ? (Collection)this.typedLinkSpecifiers.stream().map(TypedLinkSpecifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typedLinkSpecifiers(Collection<TypedLinkSpecifier> typedLinkSpecifiers) {
            this.typedLinkSpecifiers = TypedLinkSpecifierListCopier.copy(typedLinkSpecifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typedLinkSpecifiers(TypedLinkSpecifier ... typedLinkSpecifiers) {
            this.typedLinkSpecifiers(Arrays.asList(typedLinkSpecifiers));
            return this;
        }

        public final void setTypedLinkSpecifiers(Collection<TypedLinkSpecifier.BuilderImpl> typedLinkSpecifiers) {
            this.typedLinkSpecifiers = TypedLinkSpecifierListCopier.copyFromBuilder(typedLinkSpecifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListOutgoingTypedLinksResponse build() {
            return new ListOutgoingTypedLinksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOutgoingTypedLinksResponse> {
        public Builder typedLinkSpecifiers(Collection<TypedLinkSpecifier> var1);

        public Builder typedLinkSpecifiers(TypedLinkSpecifier ... var1);

        public Builder nextToken(String var1);
    }
}

