/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.LinkNameToObjectIdentifierMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListObjectChildrenResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListObjectChildrenResponse> {
    private final Map<String, String> children;
    private final String nextToken;

    private ListObjectChildrenResponse(BuilderImpl builder) {
        this.children = builder.children;
        this.nextToken = builder.nextToken;
    }

    public Map<String, String> children() {
        return this.children;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.children());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectChildrenResponse)) {
            return false;
        }
        ListObjectChildrenResponse other = (ListObjectChildrenResponse)((Object)obj);
        return Objects.equals(this.children(), other.children()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.children() != null) {
            sb.append("Children: ").append(this.children()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Children": {
                return Optional.of(clazz.cast(this.children()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> children;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectChildrenResponse model) {
            this.children(model.children);
            this.nextToken(model.nextToken);
        }

        public final Map<String, String> getChildren() {
            return this.children;
        }

        @Override
        public final Builder children(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
            return this;
        }

        public final void setChildren(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListObjectChildrenResponse build() {
            return new ListObjectChildrenResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListObjectChildrenResponse> {
        public Builder children(Map<String, String> var1);

        public Builder nextToken(String var1);
    }
}

