/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRangeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIncomingTypedLinksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListIncomingTypedLinksRequest> {
    private final String directoryArn;
    private final ObjectReference objectReference;
    private final List<TypedLinkAttributeRange> filterAttributeRanges;
    private final TypedLinkSchemaAndFacetName filterTypedLink;
    private final String nextToken;
    private final Integer maxResults;
    private final String consistencyLevel;

    private ListIncomingTypedLinksRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.filterAttributeRanges = builder.filterAttributeRanges;
        this.filterTypedLink = builder.filterTypedLink;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public List<TypedLinkAttributeRange> filterAttributeRanges() {
        return this.filterAttributeRanges;
    }

    public TypedLinkSchemaAndFacetName filterTypedLink() {
        return this.filterTypedLink;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public String consistencyLevelString() {
        return this.consistencyLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterAttributeRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIncomingTypedLinksRequest)) {
            return false;
        }
        ListIncomingTypedLinksRequest other = (ListIncomingTypedLinksRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.filterAttributeRanges(), other.filterAttributeRanges()) && Objects.equals(this.filterTypedLink(), other.filterTypedLink()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.consistencyLevelString(), other.consistencyLevelString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.objectReference() != null) {
            sb.append("ObjectReference: ").append(this.objectReference()).append(",");
        }
        if (this.filterAttributeRanges() != null) {
            sb.append("FilterAttributeRanges: ").append(this.filterAttributeRanges()).append(",");
        }
        if (this.filterTypedLink() != null) {
            sb.append("FilterTypedLink: ").append(this.filterTypedLink()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.consistencyLevelString() != null) {
            sb.append("ConsistencyLevel: ").append(this.consistencyLevelString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "ObjectReference": {
                return Optional.of(clazz.cast(this.objectReference()));
            }
            case "FilterAttributeRanges": {
                return Optional.of(clazz.cast(this.filterAttributeRanges()));
            }
            case "FilterTypedLink": {
                return Optional.of(clazz.cast(this.filterTypedLink()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "ConsistencyLevel": {
                return Optional.of(clazz.cast(this.consistencyLevelString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference objectReference;
        private List<TypedLinkAttributeRange> filterAttributeRanges;
        private TypedLinkSchemaAndFacetName filterTypedLink;
        private String nextToken;
        private Integer maxResults;
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIncomingTypedLinksRequest model) {
            this.directoryArn(model.directoryArn);
            this.objectReference(model.objectReference);
            this.filterAttributeRanges(model.filterAttributeRanges);
            this.filterTypedLink(model.filterTypedLink);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final Collection<TypedLinkAttributeRange.Builder> getFilterAttributeRanges() {
            return this.filterAttributeRanges != null ? (Collection)this.filterAttributeRanges.stream().map(TypedLinkAttributeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copy(filterAttributeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(TypedLinkAttributeRange ... filterAttributeRanges) {
            this.filterAttributeRanges(Arrays.asList(filterAttributeRanges));
            return this;
        }

        public final void setFilterAttributeRanges(Collection<TypedLinkAttributeRange.BuilderImpl> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copyFromBuilder(filterAttributeRanges);
        }

        public final TypedLinkSchemaAndFacetName.Builder getFilterTypedLink() {
            return this.filterTypedLink != null ? this.filterTypedLink.toBuilder() : null;
        }

        @Override
        public final Builder filterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
            this.filterTypedLink = filterTypedLink;
            return this;
        }

        public final void setFilterTypedLink(TypedLinkSchemaAndFacetName.BuilderImpl filterTypedLink) {
            this.filterTypedLink = filterTypedLink != null ? filterTypedLink.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        public ListIncomingTypedLinksRequest build() {
            return new ListIncomingTypedLinksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIncomingTypedLinksRequest> {
        public Builder directoryArn(String var1);

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(objectReference)).build());
        }

        public Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> var1);

        public Builder filterAttributeRanges(TypedLinkAttributeRange ... var1);

        public Builder filterTypedLink(TypedLinkSchemaAndFacetName var1);

        default public Builder filterTypedLink(Consumer<TypedLinkSchemaAndFacetName.Builder> filterTypedLink) {
            return this.filterTypedLink((TypedLinkSchemaAndFacetName)((TypedLinkSchemaAndFacetName.Builder)TypedLinkSchemaAndFacetName.builder().apply(filterTypedLink)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);
    }
}

