/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttribute;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFacetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFacetRequest> {
    private final String schemaArn;
    private final String name;
    private final List<FacetAttribute> attributes;
    private final String objectType;

    private CreateFacetRequest(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.objectType = builder.objectType;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String name() {
        return this.name;
    }

    public List<FacetAttribute> attributes() {
        return this.attributes;
    }

    public ObjectType objectType() {
        return ObjectType.fromValue(this.objectType);
    }

    public String objectTypeString() {
        return this.objectType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFacetRequest)) {
            return false;
        }
        CreateFacetRequest other = (CreateFacetRequest)((Object)obj);
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.objectTypeString(), other.objectTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.schemaArn() != null) {
            sb.append("SchemaArn: ").append(this.schemaArn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.objectTypeString() != null) {
            sb.append("ObjectType: ").append(this.objectTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.of(clazz.cast(this.schemaArn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "ObjectType": {
                return Optional.of(clazz.cast(this.objectTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaArn;
        private String name;
        private List<FacetAttribute> attributes;
        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFacetRequest model) {
            this.schemaArn(model.schemaArn);
            this.name(model.name);
            this.attributes(model.attributes);
            this.objectType(model.objectType);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<FacetAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(FacetAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(FacetAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<FacetAttribute.BuilderImpl> attributes) {
            this.attributes = FacetAttributeListCopier.copyFromBuilder(attributes);
        }

        public final String getObjectType() {
            return this.objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public CreateFacetRequest build() {
            return new CreateFacetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder name(String var1);

        public Builder attributes(Collection<FacetAttribute> var1);

        public Builder attributes(FacetAttribute ... var1);

        public Builder objectType(String var1);

        public Builder objectType(ObjectType var1);
    }
}

