/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchReadRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchReadRequest> {
    private final String directoryArn;
    private final List<BatchReadOperation> operations;
    private final String consistencyLevel;

    private BatchReadRequest(BuilderImpl builder) {
        this.directoryArn = builder.directoryArn;
        this.operations = builder.operations;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public List<BatchReadOperation> operations() {
        return this.operations;
    }

    public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public String consistencyLevelString() {
        return this.consistencyLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operations());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadRequest)) {
            return false;
        }
        BatchReadRequest other = (BatchReadRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.operations(), other.operations()) && Objects.equals(this.consistencyLevelString(), other.consistencyLevelString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        if (this.consistencyLevelString() != null) {
            sb.append("ConsistencyLevel: ").append(this.consistencyLevelString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "Operations": {
                return Optional.of(clazz.cast(this.operations()));
            }
            case "ConsistencyLevel": {
                return Optional.of(clazz.cast(this.consistencyLevelString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<BatchReadOperation> operations;
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadRequest model) {
            this.directoryArn(model.directoryArn);
            this.operations(model.operations);
            this.consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<BatchReadOperation.Builder> getOperations() {
            return this.operations != null ? (Collection)this.operations.stream().map(BatchReadOperation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<BatchReadOperation> operations) {
            this.operations = BatchReadOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(BatchReadOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<BatchReadOperation.BuilderImpl> operations) {
            this.operations = BatchReadOperationListCopier.copyFromBuilder(operations);
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        public BatchReadRequest build() {
            return new BatchReadRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchReadRequest> {
        public Builder directoryArn(String var1);

        public Builder operations(Collection<BatchReadOperation> var1);

        public Builder operations(BatchReadOperation ... var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);
    }
}

