/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.PolicyToPath;
import software.amazon.awssdk.services.clouddirectory.model.PolicyToPathListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LookupPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, LookupPolicyResponse> {
    private final List<PolicyToPath> policyToPathList;
    private final String nextToken;

    private LookupPolicyResponse(BuilderImpl builder) {
        this.policyToPathList = builder.policyToPathList;
        this.nextToken = builder.nextToken;
    }

    public List<PolicyToPath> policyToPathList() {
        return this.policyToPathList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyToPathList() == null ? 0 : this.policyToPathList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupPolicyResponse)) {
            return false;
        }
        LookupPolicyResponse other = (LookupPolicyResponse)((Object)obj);
        if (other.policyToPathList() == null ^ this.policyToPathList() == null) {
            return false;
        }
        if (other.policyToPathList() != null && !other.policyToPathList().equals(this.policyToPathList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyToPathList() != null) {
            sb.append("PolicyToPathList: ").append(this.policyToPathList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PolicyToPath> policyToPathList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupPolicyResponse model) {
            this.setPolicyToPathList(model.policyToPathList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<PolicyToPath> getPolicyToPathList() {
            return this.policyToPathList;
        }

        @Override
        public final Builder policyToPathList(Collection<PolicyToPath> policyToPathList) {
            this.policyToPathList = PolicyToPathListCopier.copy(policyToPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyToPathList(PolicyToPath ... policyToPathList) {
            this.policyToPathList(Arrays.asList(policyToPathList));
            return this;
        }

        public final void setPolicyToPathList(Collection<PolicyToPath> policyToPathList) {
            this.policyToPathList = PolicyToPathListCopier.copy(policyToPathList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public LookupPolicyResponse build() {
            return new LookupPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LookupPolicyResponse> {
        public Builder policyToPathList(Collection<PolicyToPath> var1);

        public Builder policyToPathList(PolicyToPath ... var1);

        public Builder nextToken(String var1);
    }
}

