/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.LinkNameToObjectIdentifierMapCopier;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListObjectChildrenResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchListObjectChildrenResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchListObjectChildrenResponse> {
    private final Map<String, String> children;
    private final String nextToken;

    private BatchListObjectChildrenResponse(BuilderImpl builder) {
        this.children = builder.children;
        this.nextToken = builder.nextToken;
    }

    public Map<String, String> children() {
        return this.children;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.children() == null ? 0 : this.children().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectChildrenResponse)) {
            return false;
        }
        BatchListObjectChildrenResponse other = (BatchListObjectChildrenResponse)obj;
        if (other.children() == null ^ this.children() == null) {
            return false;
        }
        if (other.children() != null && !other.children().equals(this.children())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.children() != null) {
            sb.append("Children: ").append(this.children()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchListObjectChildrenResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, String> children;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectChildrenResponse model) {
            this.setChildren(model.children);
            this.setNextToken(model.nextToken);
        }

        public final Map<String, String> getChildren() {
            return this.children;
        }

        @Override
        public final Builder children(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
            return this;
        }

        public final void setChildren(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchListObjectChildrenResponse build() {
            return new BatchListObjectChildrenResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchListObjectChildrenResponse> {
        public Builder children(Map<String, String> var1);

        public Builder nextToken(String var1);
    }
}

