/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTypedLinkFacetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateTypedLinkFacetRequest> {
    private final String schemaArn;
    private final String name;
    private final List<TypedLinkFacetAttributeUpdate> attributeUpdates;
    private final List<String> identityAttributeOrder;

    private UpdateTypedLinkFacetRequest(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributeUpdates = builder.attributeUpdates;
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String name() {
        return this.name;
    }

    public List<TypedLinkFacetAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public List<String> identityAttributeOrder() {
        return this.identityAttributeOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.schemaArn() == null ? 0 : this.schemaArn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.attributeUpdates() == null ? 0 : this.attributeUpdates().hashCode());
        hashCode = 31 * hashCode + (this.identityAttributeOrder() == null ? 0 : this.identityAttributeOrder().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTypedLinkFacetRequest)) {
            return false;
        }
        UpdateTypedLinkFacetRequest other = (UpdateTypedLinkFacetRequest)((Object)obj);
        if (other.schemaArn() == null ^ this.schemaArn() == null) {
            return false;
        }
        if (other.schemaArn() != null && !other.schemaArn().equals(this.schemaArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.attributeUpdates() == null ^ this.attributeUpdates() == null) {
            return false;
        }
        if (other.attributeUpdates() != null && !other.attributeUpdates().equals(this.attributeUpdates())) {
            return false;
        }
        if (other.identityAttributeOrder() == null ^ this.identityAttributeOrder() == null) {
            return false;
        }
        return other.identityAttributeOrder() == null || other.identityAttributeOrder().equals(this.identityAttributeOrder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.schemaArn() != null) {
            sb.append("SchemaArn: ").append(this.schemaArn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.attributeUpdates() != null) {
            sb.append("AttributeUpdates: ").append(this.attributeUpdates()).append(",");
        }
        if (this.identityAttributeOrder() != null) {
            sb.append("IdentityAttributeOrder: ").append(this.identityAttributeOrder()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String schemaArn;
        private String name;
        private List<TypedLinkFacetAttributeUpdate> attributeUpdates;
        private List<String> identityAttributeOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTypedLinkFacetRequest model) {
            this.setSchemaArn(model.schemaArn);
            this.setName(model.name);
            this.setAttributeUpdates(model.attributeUpdates);
            this.setIdentityAttributeOrder(model.identityAttributeOrder);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TypedLinkFacetAttributeUpdate> getAttributeUpdates() {
            return this.attributeUpdates;
        }

        @Override
        public final Builder attributeUpdates(Collection<TypedLinkFacetAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = TypedLinkFacetAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(TypedLinkFacetAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        public final void setAttributeUpdates(Collection<TypedLinkFacetAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = TypedLinkFacetAttributeUpdateListCopier.copy(attributeUpdates);
        }

        public final Collection<String> getIdentityAttributeOrder() {
            return this.identityAttributeOrder;
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String ... identityAttributeOrder) {
            this.identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        public UpdateTypedLinkFacetRequest build() {
            return new UpdateTypedLinkFacetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateTypedLinkFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder name(String var1);

        public Builder attributeUpdates(Collection<TypedLinkFacetAttributeUpdate> var1);

        public Builder attributeUpdates(TypedLinkFacetAttributeUpdate ... var1);

        public Builder identityAttributeOrder(Collection<String> var1);

        public Builder identityAttributeOrder(String ... var1);
    }
}

