/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachment;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachmentListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIndexResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListIndexResponse> {
    private final List<IndexAttachment> indexAttachments;
    private final String nextToken;

    private ListIndexResponse(BuilderImpl builder) {
        this.indexAttachments = builder.indexAttachments;
        this.nextToken = builder.nextToken;
    }

    public List<IndexAttachment> indexAttachments() {
        return this.indexAttachments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.indexAttachments() == null ? 0 : this.indexAttachments().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexResponse)) {
            return false;
        }
        ListIndexResponse other = (ListIndexResponse)((Object)obj);
        if (other.indexAttachments() == null ^ this.indexAttachments() == null) {
            return false;
        }
        if (other.indexAttachments() != null && !other.indexAttachments().equals(this.indexAttachments())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.indexAttachments() != null) {
            sb.append("IndexAttachments: ").append(this.indexAttachments()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<IndexAttachment> indexAttachments;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexResponse model) {
            this.setIndexAttachments(model.indexAttachments);
            this.setNextToken(model.nextToken);
        }

        public final Collection<IndexAttachment> getIndexAttachments() {
            return this.indexAttachments;
        }

        @Override
        public final Builder indexAttachments(Collection<IndexAttachment> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copy(indexAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(IndexAttachment ... indexAttachments) {
            this.indexAttachments(Arrays.asList(indexAttachments));
            return this;
        }

        public final void setIndexAttachments(Collection<IndexAttachment> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copy(indexAttachments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListIndexResponse build() {
            return new ListIndexResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIndexResponse> {
        public Builder indexAttachments(Collection<IndexAttachment> var1);

        public Builder indexAttachments(IndexAttachment ... var1);

        public Builder nextToken(String var1);
    }
}

